(() => {
  'use strict';

  const normalize = (s) => String(s || '').trim();
  const normalizeLower = (s) => normalize(s).toLowerCase();

  const nowIso = () => new Date().toISOString();

  const pushLocalList = (key, item, limit = 5000) => {
    try {
      let list = [];
      try {
        list = JSON.parse(localStorage.getItem(key) || '[]');
      } catch {}
      if (!Array.isArray(list)) list = [];
      list.unshift(item);
      if (list.length > limit) list = list.slice(0, limit);
      localStorage.setItem(key, JSON.stringify(list));
    } catch {}
  };

  const buildTrackUrls = () => {
    const urls = [];
    try {
      urls.push(new URL('/pagos/track.php', window.location.origin).toString());
      urls.push(new URL('/es/eventos/pagos/track.php', window.location.origin).toString());
    } catch {}
    return Array.from(new Set(urls)).filter(Boolean);
  };

  const sendTrack = (type, eventKey = '') => {
    const payload = {
      ts: nowIso(),
      p: window.location.pathname || '',
      r: document.referrer || '',
      t: eventKey ? `${type}|${eventKey}` : type,
    };

    if (window.location.protocol === 'file:') {
      pushLocalList('tm_offline_visits', payload);
      return;
    }

    const body = new URLSearchParams({ p: payload.p, r: payload.r, t: payload.t }).toString();
    const urls = buildTrackUrls();
    urls.forEach((u) => {
      try {
        fetch(u, {
          method: 'POST',
          headers: { 'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8' },
          body,
          credentials: 'include',
          keepalive: true,
          cache: 'no-store',
        }).catch(() => {});
      } catch {}
    });
  };

  const detectEventKey = () => {
    const p = String(window.location.pathname || '').toLowerCase();
    if (p.includes('/shakira-boletos/')) return 'shakira';
    if (p.includes('/los-angeles-negros-boletos/')) return 'angeles';
    return '';
  };

  const toPasarelaUrl = (eventKey) => {
    const url = new URL('../../pagos/pasarela.html', window.location.href);
    url.searchParams.set('event', eventKey);
    url.searchParams.set('from', window.location.pathname + window.location.search);
    return url.toString();
  };

  const isBuscarBoletosCta = (el) => {
    if (!el) return false;
    const text = normalizeLower(el.textContent);
    const aria = normalizeLower(el.getAttribute && el.getAttribute('aria-label'));
    const title = normalizeLower(el.getAttribute && el.getAttribute('title'));
    const combined = `${text} ${aria} ${title}`.replace(/\s+/g, ' ').trim();
    // Matches "Buscar boletos" even if spacing differs.
    return combined.includes('buscar boletos') || (combined.includes('buscar') && combined.includes('boletos'));
  };

  const intercept = () => {
    const eventKey = detectEventKey();
    if (!eventKey) return;

    sendTrack('page_view', eventKey);

    document.addEventListener(
      'click',
      (e) => {
        const t = e.target instanceof Element ? e.target : null;
        if (!t) return;

        const clickable = t.closest('a,button,[role="button"],[role="link"]');
        if (!clickable) return;
        if (!isBuscarBoletosCta(clickable)) return;

        sendTrack('cta_buscar_boletos', eventKey);

        e.preventDefault();
        e.stopPropagation();
        if (typeof e.stopImmediatePropagation === 'function') e.stopImmediatePropagation();

        window.location.href = toPasarelaUrl(eventKey);
      },
      true
    );
  };

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', intercept);
  } else {
    intercept();
  }
})();
