<?php
declare(strict_types=1);

// Exponer una vista segura de config.json para el frontend.
// .htaccess bloquea acceso directo a .json, por eso se usa este endpoint.

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

$path = __DIR__ . '/config.json';
$raw = is_file($path) ? @file_get_contents($path) : false;
if (is_string($raw)) {
  // Quita UTF-8 BOM si existe (json_decode falla con BOM).
  if (substr($raw, 0, 3) === "\xEF\xBB\xBF") $raw = substr($raw, 3);
  $raw = ltrim($raw, "\xEF\xBB\xBF\xFE\xFF\xFF\xFE");
}
$cfg = is_string($raw) ? json_decode($raw, true) : null;
if (!is_array($cfg)) $cfg = [];

$out = [
  'title' => (string)($cfg['title'] ?? ''),
  'subtitle' => (string)($cfg['subtitle'] ?? ''),
  'support_whatsapp_url' => (string)($cfg['support_whatsapp_url'] ?? ''),
  'methods' => [],
];

$methods = $cfg['methods'] ?? [];
if (is_array($methods)) {
  foreach ($methods as $m) {
    if (!is_array($m)) continue;
    $out['methods'][] = [
      'id' => (string)($m['id'] ?? ''),
      'label' => (string)($m['label'] ?? ''),
      'description' => (string)($m['description'] ?? ''),
      'type' => (string)($m['type'] ?? ''),
      'url' => (string)($m['url'] ?? ''),
      'image' => (string)($m['image'] ?? ''),
    ];
  }
}

echo json_encode($out, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
