<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

$path = __DIR__ . '/tm-events.json';
$raw = is_file($path) ? @file_get_contents($path) : false;
if (is_string($raw)) {
  // Remove UTF-8 BOM if present.
  if (substr($raw, 0, 3) === "\xEF\xBB\xBF") $raw = substr($raw, 3);
  $raw = ltrim($raw, "\xEF\xBB\xBF\xFE\xFF\xFF\xFE");
}

$cfg = is_string($raw) ? json_decode($raw, true) : null;
if (!is_array($cfg)) {
  $cfg = [
    'currency' => 'MXN',
    'events' => new stdClass(),
  ];
}

echo json_encode($cfg, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
