param(
  [int] $Port = 8000,
  [string] $Bind = '127.0.0.1',
  [string] $Open = ''
)

$ErrorActionPreference = 'Stop'

function Test-PortFree([string] $bind, [int] $port) {
  try {
    $ip = [System.Net.IPAddress]::Parse($bind)
    $listener = [System.Net.Sockets.TcpListener]::new($ip, $port)
    $listener.Start()
    $listener.Stop()
    return $true
  } catch {
    return $false
  }
}

if (-not (Test-PortFree $Bind $Port)) {
  $originalPort = $Port
  $found = $false
  foreach ($candidate in ($originalPort + 1)..($originalPort + 50)) {
    if (Test-PortFree $Bind $candidate) {
      Write-Warning "El puerto $originalPort está en uso. Usando $candidate."
      $Port = $candidate
      $found = $true
      break
    }
  }
  if (-not $found) {
    throw "No hay puertos libres entre $($originalPort + 1) y $($originalPort + 50). Prueba con -Port 8080."
  }
}

function Resolve-OpenPath([string] $openPath) {
  if ([string]::IsNullOrWhiteSpace($openPath)) { return '' }
  $p = $openPath.Trim()
  $p = $p -replace '\\', '/'
  if ($p.StartsWith('/')) { $p = $p.Substring(1) }
  return $p
}

$openPath = Resolve-OpenPath $Open
$baseUrl = "http://$Bind`:$Port"
$url = if ($openPath) { "$baseUrl/$openPath" } else { "$baseUrl/" }

Write-Host "Serving: $PWD"
Write-Host "URL:     $url"
Write-Host ""
Write-Host "Stop with Ctrl+C"
Write-Host ""

try { Start-Process $url | Out-Null } catch {}

if (Get-Command php -ErrorAction SilentlyContinue) {
  php -S "$Bind`:$Port" -t "$PWD"
} elseif (Get-Command py -ErrorAction SilentlyContinue) {
  py -3 -m http.server $Port --bind $Bind
} elseif (Get-Command python -ErrorAction SilentlyContinue) {
  python -m http.server $Port --bind $Bind
} else {
  throw "No se encontró PHP ni Python. Instala PHP (recomendado) o Python 3, o agrega 'php'/'python' (o 'py') al PATH."
}
